/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import mlsoft.mct.MlArray;
import mlsoft.mct.MlArrayPos;
import mlsoft.mct.MlGrid;
import mlsoft.mct.MlGridCell;
import mlsoft.mct.MlGridCellValues;
import mlsoft.mct.MlGridColumn;
import mlsoft.mct.MlGridRowValues;

public class MlGridRow
implements MlArrayPos {
    protected MlArray _cellArray = new MlArray(false);
    protected MlGrid _grid;
    protected int _heightInPixels;
    protected boolean _heightInPixelsValid;
    protected int _pos;
    protected MlGridRowValues _values;
    protected int _visiblePos;

    public MlGridRow(MlGrid mlGrid, MlGridRowValues mlGridRowValues) {
        this._grid = mlGrid;
        this._pos = 0;
        this._heightInPixels = 0;
        this._heightInPixelsValid = false;
        this._values = mlGridRowValues;
        this._visiblePos = 0;
    }

    public void setValues(MlGridRowValues mlGridRowValues) {
        this._values = mlGridRowValues;
    }

    public MlGridRowValues getValues() {
        return this._values;
    }

    public MlArray getCells() {
        return this._cellArray;
    }

    public void setPos(int n) {
        this._pos = n;
    }

    public int getPos() {
        return this._pos;
    }

    public int getVisiblePos() {
        return this._visiblePos;
    }

    public boolean isHidden() {
        return this._values.height == 0;
    }

    public boolean isSelected() {
        return this._values.selected;
    }

    public void setSelected(boolean bl) {
        this._values.selected = bl;
    }

    public void setVisiblePos(int n) {
        this._visiblePos = n;
    }

    public int heightInPixels() {
        if (this._values.sizePolicy == 0) {
            return this._values.height;
        }
        if (this._values.height == 0) {
            return 0;
        }
        if (!this._heightInPixelsValid) {
            int n;
            int n2 = this._cellArray.getCount();
            if (n2 == 0) {
                MlGridCellValues mlGridCellValues = this._grid._defCellValues;
                n = 4 + this._values.height * mlGridCellValues.fontHeight + mlGridCellValues.topMargin + mlGridCellValues.bottomMargin;
            } else {
                n = 0;
            }
            int n3 = 0;
            while (n3 < n2) {
                MlGridColumn mlGridColumn;
                MlGridCell mlGridCell = (MlGridCell)this._cellArray.get(n3);
                int n4 = mlGridCell.getPreferredHeight(this._grid, this, mlGridColumn = (MlGridColumn)this._grid._colArray.get(n3), this._values.height);
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
            this._heightInPixels = n;
            this._heightInPixelsValid = true;
        }
        return this._heightInPixels;
    }

    public void heightChanged() {
        this._heightInPixelsValid = false;
    }
}

